package zio.aws.dax.model
import scala.jdk.CollectionConverters.*
sealed trait SSEStatus {
  def unwrap: software.amazon.awssdk.services.dax.model.SSEStatus
}
object SSEStatus {
  def wrap(
      value: software.amazon.awssdk.services.dax.model.SSEStatus
  ): zio.aws.dax.model.SSEStatus = value match {
    case software.amazon.awssdk.services.dax.model.SSEStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dax.model.SSEStatus.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.dax.model.SSEStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.dax.model.SSEStatus.DISABLING =>
      val r = DISABLING
      r
    case software.amazon.awssdk.services.dax.model.SSEStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.dax.model.SSEStatus {
    override def unwrap: software.amazon.awssdk.services.dax.model.SSEStatus =
      software.amazon.awssdk.services.dax.model.SSEStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLING extends zio.aws.dax.model.SSEStatus {
    override def unwrap: software.amazon.awssdk.services.dax.model.SSEStatus =
      software.amazon.awssdk.services.dax.model.SSEStatus.ENABLING
  }
  case object ENABLED extends zio.aws.dax.model.SSEStatus {
    override def unwrap: software.amazon.awssdk.services.dax.model.SSEStatus =
      software.amazon.awssdk.services.dax.model.SSEStatus.ENABLED
  }
  case object DISABLING extends zio.aws.dax.model.SSEStatus {
    override def unwrap: software.amazon.awssdk.services.dax.model.SSEStatus =
      software.amazon.awssdk.services.dax.model.SSEStatus.DISABLING
  }
  case object DISABLED extends zio.aws.dax.model.SSEStatus {
    override def unwrap: software.amazon.awssdk.services.dax.model.SSEStatus =
      software.amazon.awssdk.services.dax.model.SSEStatus.DISABLED
  }
}
