package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SecurityGroupMembership(
    securityGroupIdentifier: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.SecurityGroupMembership = {
    import SecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.SecurityGroupMembership
      .builder()
      .optionallyWith(
        securityGroupIdentifier.map(value => value: java.lang.String)
      )(_.securityGroupIdentifier)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.SecurityGroupMembership.ReadOnly =
    zio.aws.dax.model.SecurityGroupMembership.wrap(buildAwsValue())
}
object SecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.SecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.SecurityGroupMembership =
      zio.aws.dax.model.SecurityGroupMembership(
        securityGroupIdentifier.map(value => value),
        status.map(value => value)
      )
    def securityGroupIdentifier: Option[String]
    def status: Option[String]
    def getSecurityGroupIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("securityGroupIdentifier", securityGroupIdentifier)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.SecurityGroupMembership
  ) extends zio.aws.dax.model.SecurityGroupMembership.ReadOnly {
    override val securityGroupIdentifier: Option[String] =
      scala.Option(impl.securityGroupIdentifier()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.SecurityGroupMembership
  ): zio.aws.dax.model.SecurityGroupMembership.ReadOnly = new Wrapper(impl)
}
