package zio.aws.dax.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.dax.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.dax.model.SourceType
  ): zio.aws.dax.model.SourceType = value match {
    case software.amazon.awssdk.services.dax.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dax.model.SourceType.CLUSTER =>
      val r = CLUSTER
      r
    case software.amazon.awssdk.services.dax.model.SourceType.PARAMETER_GROUP =>
      val r = PARAMETER_GROUP
      r
    case software.amazon.awssdk.services.dax.model.SourceType.SUBNET_GROUP =>
      val r = SUBNET_GROUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.dax.model.SourceType {
    override def unwrap: software.amazon.awssdk.services.dax.model.SourceType =
      software.amazon.awssdk.services.dax.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLUSTER extends zio.aws.dax.model.SourceType {
    override def unwrap: software.amazon.awssdk.services.dax.model.SourceType =
      software.amazon.awssdk.services.dax.model.SourceType.CLUSTER
  }
  case object PARAMETER_GROUP extends zio.aws.dax.model.SourceType {
    override def unwrap: software.amazon.awssdk.services.dax.model.SourceType =
      software.amazon.awssdk.services.dax.model.SourceType.PARAMETER_GROUP
  }
  case object SUBNET_GROUP extends zio.aws.dax.model.SourceType {
    override def unwrap: software.amazon.awssdk.services.dax.model.SourceType =
      software.amazon.awssdk.services.dax.model.SourceType.SUBNET_GROUP
  }
}
