package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Subnet(
    subnetIdentifier: Option[String] = None,
    subnetAvailabilityZone: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dax.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.Subnet
      .builder()
      .optionallyWith(subnetIdentifier.map(value => value: java.lang.String))(
        _.subnetIdentifier
      )
      .optionallyWith(
        subnetAvailabilityZone.map(value => value: java.lang.String)
      )(_.subnetAvailabilityZone)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.Subnet.ReadOnly =
    zio.aws.dax.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dax.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.Subnet = zio.aws.dax.model.Subnet(
      subnetIdentifier.map(value => value),
      subnetAvailabilityZone.map(value => value)
    )
    def subnetIdentifier: Option[String]
    def subnetAvailabilityZone: Option[String]
    def getSubnetIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifier)
    def getSubnetAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("subnetAvailabilityZone", subnetAvailabilityZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.Subnet
  ) extends zio.aws.dax.model.Subnet.ReadOnly {
    override val subnetIdentifier: Option[String] =
      scala.Option(impl.subnetIdentifier()).map(value => value: String)
    override val subnetAvailabilityZone: Option[String] =
      scala.Option(impl.subnetAvailabilityZone()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.Subnet
  ): zio.aws.dax.model.Subnet.ReadOnly = new Wrapper(impl)
}
