package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SubnetGroup(
    subnetGroupName: Option[String] = None,
    description: Option[String] = None,
    vpcId: Option[String] = None,
    subnets: Option[Iterable[zio.aws.dax.model.Subnet]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dax.model.SubnetGroup = {
    import SubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.SubnetGroup
      .builder()
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.SubnetGroup.ReadOnly =
    zio.aws.dax.model.SubnetGroup.wrap(buildAwsValue())
}
object SubnetGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dax.model.SubnetGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.SubnetGroup =
      zio.aws.dax.model.SubnetGroup(
        subnetGroupName.map(value => value),
        description.map(value => value),
        vpcId.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subnetGroupName: Option[String]
    def description: Option[String]
    def vpcId: Option[String]
    def subnets: Option[List[zio.aws.dax.model.Subnet.ReadOnly]]
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.dax.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.SubnetGroup
  ) extends zio.aws.dax.model.SubnetGroup.ReadOnly {
    override val subnetGroupName: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val subnets: Option[List[zio.aws.dax.model.Subnet.ReadOnly]] =
      scala
        .Option(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dax.model.Subnet.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.SubnetGroup
  ): zio.aws.dax.model.SubnetGroup.ReadOnly = new Wrapper(impl)
}
