package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceName: String,
    tags: Iterable[zio.aws.dax.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.TagResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.TagResourceRequest.ReadOnly =
    zio.aws.dax.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.TagResourceRequest =
      zio.aws.dax.model.TagResourceRequest(
        resourceName,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceName: String
    def tags: List[zio.aws.dax.model.Tag.ReadOnly]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getTags: ZIO[Any, Nothing, List[zio.aws.dax.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.TagResourceRequest
  ) extends zio.aws.dax.model.TagResourceRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val tags: List[zio.aws.dax.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.dax.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.TagResourceRequest
  ): zio.aws.dax.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
