package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TagResourceResponse(
    tags: Option[Iterable[zio.aws.dax.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.TagResourceResponse = {
    import TagResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.TagResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.TagResourceResponse.ReadOnly =
    zio.aws.dax.model.TagResourceResponse.wrap(buildAwsValue())
}
object TagResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.TagResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.TagResourceResponse =
      zio.aws.dax.model.TagResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Option[List[zio.aws.dax.model.Tag.ReadOnly]]
    def getTags: ZIO[Any, AwsError, List[zio.aws.dax.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.TagResourceResponse
  ) extends zio.aws.dax.model.TagResourceResponse.ReadOnly {
    override val tags: Option[List[zio.aws.dax.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dax.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.TagResourceResponse
  ): zio.aws.dax.model.TagResourceResponse.ReadOnly = new Wrapper(impl)
}
