package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceName: String,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.UntagResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.UntagResourceRequest.ReadOnly =
    zio.aws.dax.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.UntagResourceRequest =
      zio.aws.dax.model.UntagResourceRequest(resourceName, tagKeys)
    def resourceName: String
    def tagKeys: List[String]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.UntagResourceRequest
  ) extends zio.aws.dax.model.UntagResourceRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.UntagResourceRequest
  ): zio.aws.dax.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
