package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateClusterRequest(
    clusterName: String,
    description: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    notificationTopicArn: Option[String] = None,
    notificationTopicStatus: Option[String] = None,
    parameterGroupName: Option[String] = None,
    securityGroupIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.UpdateClusterRequest = {
    import UpdateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.UpdateClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        notificationTopicStatus.map(value => value: java.lang.String)
      )(_.notificationTopicStatus)
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.UpdateClusterRequest.ReadOnly =
    zio.aws.dax.model.UpdateClusterRequest.wrap(buildAwsValue())
}
object UpdateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.UpdateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.UpdateClusterRequest =
      zio.aws.dax.model.UpdateClusterRequest(
        clusterName,
        description.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        notificationTopicArn.map(value => value),
        notificationTopicStatus.map(value => value),
        parameterGroupName.map(value => value),
        securityGroupIds.map(value => value)
      )
    def clusterName: String
    def description: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def notificationTopicArn: Option[String]
    def notificationTopicStatus: Option[String]
    def parameterGroupName: Option[String]
    def securityGroupIds: Option[List[String]]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getNotificationTopicStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("notificationTopicStatus", notificationTopicStatus)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.UpdateClusterRequest
  ) extends zio.aws.dax.model.UpdateClusterRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val notificationTopicArn: Option[String] =
      scala.Option(impl.notificationTopicArn()).map(value => value: String)
    override val notificationTopicStatus: Option[String] =
      scala.Option(impl.notificationTopicStatus()).map(value => value: String)
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.UpdateClusterRequest
  ): zio.aws.dax.model.UpdateClusterRequest.ReadOnly = new Wrapper(impl)
}
