package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateClusterResponse(
    cluster: Option[zio.aws.dax.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.UpdateClusterResponse = {
    import UpdateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.UpdateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.UpdateClusterResponse.ReadOnly =
    zio.aws.dax.model.UpdateClusterResponse.wrap(buildAwsValue())
}
object UpdateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.UpdateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.UpdateClusterResponse = zio.aws.dax.model
      .UpdateClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.dax.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.dax.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.UpdateClusterResponse
  ) extends zio.aws.dax.model.UpdateClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.dax.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.dax.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.UpdateClusterResponse
  ): zio.aws.dax.model.UpdateClusterResponse.ReadOnly = new Wrapper(impl)
}
