package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateParameterGroupRequest(
    parameterGroupName: String,
    parameterNameValues: Iterable[zio.aws.dax.model.ParameterNameValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest = {
    import UpdateParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .parameterNameValues(parameterNameValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dax.model.UpdateParameterGroupRequest.ReadOnly =
    zio.aws.dax.model.UpdateParameterGroupRequest.wrap(buildAwsValue())
}
object UpdateParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.UpdateParameterGroupRequest =
      zio.aws.dax.model.UpdateParameterGroupRequest(
        parameterGroupName,
        parameterNameValues.map { item =>
          item.asEditable
        }
      )
    def parameterGroupName: String
    def parameterNameValues: List[zio.aws.dax.model.ParameterNameValue.ReadOnly]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getParameterNameValues: ZIO[Any, Nothing, List[
      zio.aws.dax.model.ParameterNameValue.ReadOnly
    ]] = ZIO.succeed(parameterNameValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest
  ) extends zio.aws.dax.model.UpdateParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val parameterNameValues
        : List[zio.aws.dax.model.ParameterNameValue.ReadOnly] = impl
      .parameterNameValues()
      .asScala
      .map { item =>
        zio.aws.dax.model.ParameterNameValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest
  ): zio.aws.dax.model.UpdateParameterGroupRequest.ReadOnly = new Wrapper(impl)
}
