package zio.aws.dax.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateSubnetGroupResponse(
    subnetGroup: Option[zio.aws.dax.model.SubnetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse = {
    import UpdateSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse
      .builder()
      .optionallyWith(subnetGroup.map(value => value.buildAwsValue()))(
        _.subnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.dax.model.UpdateSubnetGroupResponse.ReadOnly =
    zio.aws.dax.model.UpdateSubnetGroupResponse.wrap(buildAwsValue())
}
object UpdateSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dax.model.UpdateSubnetGroupResponse =
      zio.aws.dax.model
        .UpdateSubnetGroupResponse(subnetGroup.map(value => value.asEditable))
    def subnetGroup: Option[zio.aws.dax.model.SubnetGroup.ReadOnly]
    def getSubnetGroup
        : ZIO[Any, AwsError, zio.aws.dax.model.SubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("subnetGroup", subnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse
  ) extends zio.aws.dax.model.UpdateSubnetGroupResponse.ReadOnly {
    override val subnetGroup: Option[zio.aws.dax.model.SubnetGroup.ReadOnly] =
      scala
        .Option(impl.subnetGroup())
        .map(value => zio.aws.dax.model.SubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse
  ): zio.aws.dax.model.UpdateSubnetGroupResponse.ReadOnly = new Wrapper(impl)
}
