package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{URL, Name, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Artifact(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    `type`: Option[zio.aws.devicefarm.model.ArtifactType] = None,
    extension: Option[String] = None,
    url: Option[URL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Artifact = {
    import Artifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Artifact
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(extension.map(value => value: java.lang.String))(
        _.extension
      )
      .optionallyWith(url.map(value => URL.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Artifact.ReadOnly =
    zio.aws.devicefarm.model.Artifact.wrap(buildAwsValue())
}
object Artifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Artifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Artifact =
      zio.aws.devicefarm.model.Artifact(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        extension.map(value => value),
        url.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def `type`: Option[zio.aws.devicefarm.model.ArtifactType]
    def extension: Option[String]
    def url: Option[URL]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.ArtifactType] =
      AwsError.unwrapOptionField("type", `type`)
    def getExtension: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("extension", `extension`)
    def getUrl: ZIO[Any, AwsError, URL] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Artifact
  ) extends zio.aws.devicefarm.model.Artifact.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val `type`: Option[zio.aws.devicefarm.model.ArtifactType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.ArtifactType.wrap(value))
    override val extension: Option[String] =
      scala.Option(impl.extension()).map(value => value: String)
    override val url: Option[URL] = scala
      .Option(impl.url())
      .map(value => zio.aws.devicefarm.model.primitives.URL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Artifact
  ): zio.aws.devicefarm.model.Artifact.ReadOnly = new Wrapper(impl)
}
