package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CPU(
    frequency: Option[String] = None,
    architecture: Option[String] = None,
    clock: Option[Double] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.devicefarm.model.CPU = {
    import CPU.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CPU
      .builder()
      .optionallyWith(frequency.map(value => value: java.lang.String))(
        _.frequency
      )
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(clock.map(value => value: java.lang.Double))(_.clock)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CPU.ReadOnly =
    zio.aws.devicefarm.model.CPU.wrap(buildAwsValue())
}
object CPU {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.CPU] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CPU = zio.aws.devicefarm.model.CPU(
      frequency.map(value => value),
      architecture.map(value => value),
      clock.map(value => value)
    )
    def frequency: Option[String]
    def architecture: Option[String]
    def clock: Option[Double]
    def getFrequency: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getClock: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("clock", clock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CPU
  ) extends zio.aws.devicefarm.model.CPU.ReadOnly {
    override val frequency: Option[String] =
      scala.Option(impl.frequency()).map(value => value: String)
    override val architecture: Option[String] =
      scala.Option(impl.architecture()).map(value => value: String)
    override val clock: Option[Double] =
      scala.Option(impl.clock()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CPU
  ): zio.aws.devicefarm.model.CPU.ReadOnly = new Wrapper(impl)
}
