package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Counters(
    total: Option[Integer] = None,
    passed: Option[Integer] = None,
    failed: Option[Integer] = None,
    warned: Option[Integer] = None,
    errored: Option[Integer] = None,
    stopped: Option[Integer] = None,
    skipped: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Counters = {
    import Counters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Counters
      .builder()
      .optionallyWith(
        total.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.total)
      .optionallyWith(
        passed.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.passed)
      .optionallyWith(
        failed.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.failed)
      .optionallyWith(
        warned.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.warned)
      .optionallyWith(
        errored.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.errored)
      .optionallyWith(
        stopped.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.stopped)
      .optionallyWith(
        skipped.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.skipped)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Counters.ReadOnly =
    zio.aws.devicefarm.model.Counters.wrap(buildAwsValue())
}
object Counters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Counters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Counters =
      zio.aws.devicefarm.model.Counters(
        total.map(value => value),
        passed.map(value => value),
        failed.map(value => value),
        warned.map(value => value),
        errored.map(value => value),
        stopped.map(value => value),
        skipped.map(value => value)
      )
    def total: Option[Integer]
    def passed: Option[Integer]
    def failed: Option[Integer]
    def warned: Option[Integer]
    def errored: Option[Integer]
    def stopped: Option[Integer]
    def skipped: Option[Integer]
    def getTotal: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("total", total)
    def getPassed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("passed", passed)
    def getFailed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failed", failed)
    def getWarned: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("warned", warned)
    def getErrored: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("errored", errored)
    def getStopped: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getSkipped: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("skipped", skipped)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Counters
  ) extends zio.aws.devicefarm.model.Counters.ReadOnly {
    override val total: Option[Integer] = scala
      .Option(impl.total())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val passed: Option[Integer] = scala
      .Option(impl.passed())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val failed: Option[Integer] = scala
      .Option(impl.failed())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val warned: Option[Integer] = scala
      .Option(impl.warned())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val errored: Option[Integer] = scala
      .Option(impl.errored())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val stopped: Option[Integer] = scala
      .Option(impl.stopped())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val skipped: Option[Integer] = scala
      .Option(impl.skipped())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Counters
  ): zio.aws.devicefarm.model.Counters.ReadOnly = new Wrapper(impl)
}
