package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  Integer,
  Message,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDevicePoolRequest(
    projectArn: AmazonResourceName,
    name: Name,
    description: Option[Message] = None,
    rules: Iterable[zio.aws.devicefarm.model.Rule],
    maxDevices: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest = {
    import CreateDevicePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest
      .builder()
      .projectArn(AmazonResourceName.unwrap(projectArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxDevices.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxDevices)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateDevicePoolRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateDevicePoolRequest.wrap(buildAwsValue())
}
object CreateDevicePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateDevicePoolRequest =
      zio.aws.devicefarm.model.CreateDevicePoolRequest(
        projectArn,
        name,
        description.map(value => value),
        rules.map { item =>
          item.asEditable
        },
        maxDevices.map(value => value)
      )
    def projectArn: AmazonResourceName
    def name: Name
    def description: Option[Message]
    def rules: List[zio.aws.devicefarm.model.Rule.ReadOnly]
    def maxDevices: Option[Integer]
    def getProjectArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(projectArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.devicefarm.model.Rule.ReadOnly]] =
      ZIO.succeed(rules)
    def getMaxDevices: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxDevices", maxDevices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest
  ) extends zio.aws.devicefarm.model.CreateDevicePoolRequest.ReadOnly {
    override val projectArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.projectArn())
    override val name: Name =
      zio.aws.devicefarm.model.primitives.Name(impl.name())
    override val description: Option[Message] = scala
      .Option(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val rules: List[zio.aws.devicefarm.model.Rule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.devicefarm.model.Rule.wrap(item)
      }
      .toList
    override val maxDevices: Option[Integer] = scala
      .Option(impl.maxDevices())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest
  ): zio.aws.devicefarm.model.CreateDevicePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
