package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDevicePoolResponse(
    devicePool: Option[zio.aws.devicefarm.model.DevicePool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse = {
    import CreateDevicePoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse
      .builder()
      .optionallyWith(devicePool.map(value => value.buildAwsValue()))(
        _.devicePool
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateDevicePoolResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateDevicePoolResponse.wrap(buildAwsValue())
}
object CreateDevicePoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateDevicePoolResponse =
      zio.aws.devicefarm.model
        .CreateDevicePoolResponse(devicePool.map(value => value.asEditable))
    def devicePool: Option[zio.aws.devicefarm.model.DevicePool.ReadOnly]
    def getDevicePool
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePool.ReadOnly] =
      AwsError.unwrapOptionField("devicePool", devicePool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse
  ) extends zio.aws.devicefarm.model.CreateDevicePoolResponse.ReadOnly {
    override val devicePool
        : Option[zio.aws.devicefarm.model.DevicePool.ReadOnly] = scala
      .Option(impl.devicePool())
      .map(value => zio.aws.devicefarm.model.DevicePool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse
  ): zio.aws.devicefarm.model.CreateDevicePoolResponse.ReadOnly = new Wrapper(
    impl
  )
}
