package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Message, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateInstanceProfileRequest(
    name: Name,
    description: Option[Message] = None,
    packageCleanup: Option[Boolean] = None,
    excludeAppPackagesFromCleanup: Option[Iterable[String]] = None,
    rebootAfterUse: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest = {
    import CreateInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(packageCleanup.map(value => value: java.lang.Boolean))(
        _.packageCleanup
      )
      .optionallyWith(
        excludeAppPackagesFromCleanup.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAppPackagesFromCleanup)
      .optionallyWith(rebootAfterUse.map(value => value: java.lang.Boolean))(
        _.rebootAfterUse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateInstanceProfileRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateInstanceProfileRequest.wrap(buildAwsValue())
}
object CreateInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateInstanceProfileRequest =
      zio.aws.devicefarm.model.CreateInstanceProfileRequest(
        name,
        description.map(value => value),
        packageCleanup.map(value => value),
        excludeAppPackagesFromCleanup.map(value => value),
        rebootAfterUse.map(value => value)
      )
    def name: Name
    def description: Option[Message]
    def packageCleanup: Option[Boolean]
    def excludeAppPackagesFromCleanup: Option[List[String]]
    def rebootAfterUse: Option[Boolean]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getPackageCleanup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("packageCleanup", packageCleanup)
    def getExcludeAppPackagesFromCleanup: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "excludeAppPackagesFromCleanup",
        excludeAppPackagesFromCleanup
      )
    def getRebootAfterUse: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("rebootAfterUse", rebootAfterUse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest
  ) extends zio.aws.devicefarm.model.CreateInstanceProfileRequest.ReadOnly {
    override val name: Name =
      zio.aws.devicefarm.model.primitives.Name(impl.name())
    override val description: Option[Message] = scala
      .Option(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val packageCleanup: Option[Boolean] =
      scala.Option(impl.packageCleanup()).map(value => value: Boolean)
    override val excludeAppPackagesFromCleanup: Option[List[String]] = scala
      .Option(impl.excludeAppPackagesFromCleanup())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val rebootAfterUse: Option[Boolean] =
      scala.Option(impl.rebootAfterUse()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest
  ): zio.aws.devicefarm.model.CreateInstanceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
