package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateInstanceProfileResponse(
    instanceProfile: Option[zio.aws.devicefarm.model.InstanceProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse = {
    import CreateInstanceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse
      .builder()
      .optionallyWith(instanceProfile.map(value => value.buildAwsValue()))(
        _.instanceProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateInstanceProfileResponse.wrap(buildAwsValue())
}
object CreateInstanceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateInstanceProfileResponse =
      zio.aws.devicefarm.model.CreateInstanceProfileResponse(
        instanceProfile.map(value => value.asEditable)
      )
    def instanceProfile
        : Option[zio.aws.devicefarm.model.InstanceProfile.ReadOnly]
    def getInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.InstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("instanceProfile", instanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse
  ) extends zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly {
    override val instanceProfile
        : Option[zio.aws.devicefarm.model.InstanceProfile.ReadOnly] = scala
      .Option(impl.instanceProfile())
      .map(value => zio.aws.devicefarm.model.InstanceProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse
  ): zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
