package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRemoteAccessSessionConfiguration(
    billingMethod: Option[zio.aws.devicefarm.model.BillingMethod] = None,
    vpceConfigurationArns: Option[Iterable[AmazonResourceName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionConfiguration = {
    import CreateRemoteAccessSessionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionConfiguration
      .builder()
      .optionallyWith(billingMethod.map(value => value.unwrap))(_.billingMethod)
      .optionallyWith(
        vpceConfigurationArns.map(value =>
          value.map { item =>
            AmazonResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpceConfigurationArns)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly =
    zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration
      .wrap(buildAwsValue())
}
object CreateRemoteAccessSessionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration =
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration(
        billingMethod.map(value => value),
        vpceConfigurationArns.map(value => value)
      )
    def billingMethod: Option[zio.aws.devicefarm.model.BillingMethod]
    def vpceConfigurationArns: Option[List[AmazonResourceName]]
    def getBillingMethod
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.BillingMethod] =
      AwsError.unwrapOptionField("billingMethod", billingMethod)
    def getVpceConfigurationArns: ZIO[Any, AwsError, List[AmazonResourceName]] =
      AwsError.unwrapOptionField("vpceConfigurationArns", vpceConfigurationArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionConfiguration
  ) extends zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly {
    override val billingMethod: Option[zio.aws.devicefarm.model.BillingMethod] =
      scala
        .Option(impl.billingMethod())
        .map(value => zio.aws.devicefarm.model.BillingMethod.wrap(value))
    override val vpceConfigurationArns: Option[List[AmazonResourceName]] = scala
      .Option(impl.vpceConfigurationArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionConfiguration
  ): zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly =
    new Wrapper(impl)
}
