package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ClientId,
  Name,
  SshPublicKey,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRemoteAccessSessionRequest(
    projectArn: AmazonResourceName,
    deviceArn: AmazonResourceName,
    instanceArn: Option[AmazonResourceName] = None,
    sshPublicKey: Option[SshPublicKey] = None,
    remoteDebugEnabled: Option[Boolean] = None,
    remoteRecordEnabled: Option[Boolean] = None,
    remoteRecordAppArn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    clientId: Option[ClientId] = None,
    configuration: Option[
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration
    ] = None,
    interactionMode: Option[zio.aws.devicefarm.model.InteractionMode] = None,
    skipAppResign: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest = {
    import CreateRemoteAccessSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest
      .builder()
      .projectArn(AmazonResourceName.unwrap(projectArn): java.lang.String)
      .deviceArn(AmazonResourceName.unwrap(deviceArn): java.lang.String)
      .optionallyWith(
        instanceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.instanceArn)
      .optionallyWith(
        sshPublicKey.map(value => SshPublicKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .optionallyWith(
        remoteDebugEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteDebugEnabled)
      .optionallyWith(
        remoteRecordEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteRecordEnabled)
      .optionallyWith(
        remoteRecordAppArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.remoteRecordAppArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(interactionMode.map(value => value.unwrap))(
        _.interactionMode
      )
      .optionallyWith(skipAppResign.map(value => value: java.lang.Boolean))(
        _.skipAppResign
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest
      .wrap(buildAwsValue())
}
object CreateRemoteAccessSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest =
      zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest(
        projectArn,
        deviceArn,
        instanceArn.map(value => value),
        sshPublicKey.map(value => value),
        remoteDebugEnabled.map(value => value),
        remoteRecordEnabled.map(value => value),
        remoteRecordAppArn.map(value => value),
        name.map(value => value),
        clientId.map(value => value),
        configuration.map(value => value.asEditable),
        interactionMode.map(value => value),
        skipAppResign.map(value => value)
      )
    def projectArn: AmazonResourceName
    def deviceArn: AmazonResourceName
    def instanceArn: Option[AmazonResourceName]
    def sshPublicKey: Option[SshPublicKey]
    def remoteDebugEnabled: Option[Boolean]
    def remoteRecordEnabled: Option[Boolean]
    def remoteRecordAppArn: Option[AmazonResourceName]
    def name: Option[Name]
    def clientId: Option[ClientId]
    def configuration: Option[
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly
    ]
    def interactionMode: Option[zio.aws.devicefarm.model.InteractionMode]
    def skipAppResign: Option[Boolean]
    def getProjectArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(projectArn)
    def getDeviceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(deviceArn)
    def getInstanceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getSshPublicKey: ZIO[Any, AwsError, SshPublicKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
    def getRemoteDebugEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteDebugEnabled", remoteDebugEnabled)
    def getRemoteRecordEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteRecordEnabled", remoteRecordEnabled)
    def getRemoteRecordAppArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("remoteRecordAppArn", remoteRecordAppArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getInteractionMode
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.InteractionMode] =
      AwsError.unwrapOptionField("interactionMode", interactionMode)
    def getSkipAppResign: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipAppResign", skipAppResign)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest
  ) extends zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest.ReadOnly {
    override val projectArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.projectArn())
    override val deviceArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.deviceArn())
    override val instanceArn: Option[AmazonResourceName] = scala
      .Option(impl.instanceArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val sshPublicKey: Option[SshPublicKey] = scala
      .Option(impl.sshPublicKey())
      .map(value => zio.aws.devicefarm.model.primitives.SshPublicKey(value))
    override val remoteDebugEnabled: Option[Boolean] =
      scala.Option(impl.remoteDebugEnabled()).map(value => value: Boolean)
    override val remoteRecordEnabled: Option[Boolean] =
      scala.Option(impl.remoteRecordEnabled()).map(value => value: Boolean)
    override val remoteRecordAppArn: Option[AmazonResourceName] = scala
      .Option(impl.remoteRecordAppArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val clientId: Option[ClientId] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.devicefarm.model.primitives.ClientId(value))
    override val configuration: Option[
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration
          .wrap(value)
      )
    override val interactionMode
        : Option[zio.aws.devicefarm.model.InteractionMode] = scala
      .Option(impl.interactionMode())
      .map(value => zio.aws.devicefarm.model.InteractionMode.wrap(value))
    override val skipAppResign: Option[Boolean] =
      scala.Option(impl.skipAppResign()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest
  ): zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest.ReadOnly =
    new Wrapper(impl)
}
