package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTestGridProjectResponse(
    testGridProject: Option[zio.aws.devicefarm.model.TestGridProject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectResponse = {
    import CreateTestGridProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectResponse
      .builder()
      .optionallyWith(testGridProject.map(value => value.buildAwsValue()))(
        _.testGridProject
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateTestGridProjectResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateTestGridProjectResponse.wrap(buildAwsValue())
}
object CreateTestGridProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateTestGridProjectResponse =
      zio.aws.devicefarm.model.CreateTestGridProjectResponse(
        testGridProject.map(value => value.asEditable)
      )
    def testGridProject
        : Option[zio.aws.devicefarm.model.TestGridProject.ReadOnly]
    def getTestGridProject: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridProject.ReadOnly
    ] = AwsError.unwrapOptionField("testGridProject", testGridProject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectResponse
  ) extends zio.aws.devicefarm.model.CreateTestGridProjectResponse.ReadOnly {
    override val testGridProject
        : Option[zio.aws.devicefarm.model.TestGridProject.ReadOnly] = scala
      .Option(impl.testGridProject())
      .map(value => zio.aws.devicefarm.model.TestGridProject.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectResponse
  ): zio.aws.devicefarm.model.CreateTestGridProjectResponse.ReadOnly =
    new Wrapper(impl)
}
