package zio.aws.devicefarm.model
import java.lang.Integer
import zio.aws.devicefarm.model.primitives.{
  TestGridUrlExpiresInSecondsInput,
  DeviceFarmArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateTestGridUrlRequest(
    projectArn: DeviceFarmArn,
    expiresInSeconds: TestGridUrlExpiresInSecondsInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlRequest = {
    import CreateTestGridUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlRequest
      .builder()
      .projectArn(DeviceFarmArn.unwrap(projectArn): java.lang.String)
      .expiresInSeconds(
        TestGridUrlExpiresInSecondsInput.unwrap(expiresInSeconds): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateTestGridUrlRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateTestGridUrlRequest.wrap(buildAwsValue())
}
object CreateTestGridUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateTestGridUrlRequest =
      zio.aws.devicefarm.model
        .CreateTestGridUrlRequest(projectArn, expiresInSeconds)
    def projectArn: DeviceFarmArn
    def expiresInSeconds: TestGridUrlExpiresInSecondsInput
    def getProjectArn: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(projectArn)
    def getExpiresInSeconds
        : ZIO[Any, Nothing, TestGridUrlExpiresInSecondsInput] =
      ZIO.succeed(expiresInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlRequest
  ) extends zio.aws.devicefarm.model.CreateTestGridUrlRequest.ReadOnly {
    override val projectArn: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.projectArn())
    override val expiresInSeconds: TestGridUrlExpiresInSecondsInput =
      zio.aws.devicefarm.model.primitives
        .TestGridUrlExpiresInSecondsInput(impl.expiresInSeconds())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlRequest
  ): zio.aws.devicefarm.model.CreateTestGridUrlRequest.ReadOnly = new Wrapper(
    impl
  )
}
