package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{DateTime, SensitiveString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateTestGridUrlResponse(
    url: Option[SensitiveString] = None,
    expires: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse = {
    import CreateTestGridUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse
      .builder()
      .optionallyWith(
        url.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(expires.map(value => DateTime.unwrap(value): Instant))(
        _.expires
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateTestGridUrlResponse.wrap(buildAwsValue())
}
object CreateTestGridUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateTestGridUrlResponse =
      zio.aws.devicefarm.model.CreateTestGridUrlResponse(
        url.map(value => value),
        expires.map(value => value)
      )
    def url: Option[SensitiveString]
    def expires: Option[DateTime]
    def getUrl: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("url", url)
    def getExpires: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("expires", expires)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse
  ) extends zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly {
    override val url: Option[SensitiveString] = scala
      .Option(impl.url())
      .map(value => zio.aws.devicefarm.model.primitives.SensitiveString(value))
    override val expires: Option[DateTime] = scala
      .Option(impl.expires())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse
  ): zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly = new Wrapper(
    impl
  )
}
