package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ContentType,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUploadRequest(
    projectArn: AmazonResourceName,
    name: Name,
    `type`: zio.aws.devicefarm.model.UploadType,
    contentType: Option[ContentType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest = {
    import CreateUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest
      .builder()
      .projectArn(AmazonResourceName.unwrap(projectArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateUploadRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateUploadRequest.wrap(buildAwsValue())
}
object CreateUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateUploadRequest =
      zio.aws.devicefarm.model.CreateUploadRequest(
        projectArn,
        name,
        `type`,
        contentType.map(value => value)
      )
    def projectArn: AmazonResourceName
    def name: Name
    def `type`: zio.aws.devicefarm.model.UploadType
    def contentType: Option[ContentType]
    def getProjectArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(projectArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.devicefarm.model.UploadType] =
      ZIO.succeed(`type`)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest
  ) extends zio.aws.devicefarm.model.CreateUploadRequest.ReadOnly {
    override val projectArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.projectArn())
    override val name: Name =
      zio.aws.devicefarm.model.primitives.Name(impl.name())
    override val `type`: zio.aws.devicefarm.model.UploadType =
      zio.aws.devicefarm.model.UploadType.wrap(impl.`type`())
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.devicefarm.model.primitives.ContentType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest
  ): zio.aws.devicefarm.model.CreateUploadRequest.ReadOnly = new Wrapper(impl)
}
