package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUploadResponse(
    upload: Option[zio.aws.devicefarm.model.Upload] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse = {
    import CreateUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse
      .builder()
      .optionallyWith(upload.map(value => value.buildAwsValue()))(_.upload)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateUploadResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateUploadResponse.wrap(buildAwsValue())
}
object CreateUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateUploadResponse =
      zio.aws.devicefarm.model
        .CreateUploadResponse(upload.map(value => value.asEditable))
    def upload: Option[zio.aws.devicefarm.model.Upload.ReadOnly]
    def getUpload
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Upload.ReadOnly] =
      AwsError.unwrapOptionField("upload", upload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse
  ) extends zio.aws.devicefarm.model.CreateUploadResponse.ReadOnly {
    override val upload: Option[zio.aws.devicefarm.model.Upload.ReadOnly] =
      scala
        .Option(impl.upload())
        .map(value => zio.aws.devicefarm.model.Upload.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse
  ): zio.aws.devicefarm.model.CreateUploadResponse.ReadOnly = new Wrapper(impl)
}
