package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  VPCEConfigurationDescription,
  ServiceDnsName,
  VPCEServiceName,
  VPCEConfigurationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateVpceConfigurationRequest(
    vpceConfigurationName: VPCEConfigurationName,
    vpceServiceName: VPCEServiceName,
    serviceDnsName: ServiceDnsName,
    vpceConfigurationDescription: Option[VPCEConfigurationDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest = {
    import CreateVpceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest
      .builder()
      .vpceConfigurationName(
        VPCEConfigurationName.unwrap(vpceConfigurationName): java.lang.String
      )
      .vpceServiceName(
        VPCEServiceName.unwrap(vpceServiceName): java.lang.String
      )
      .serviceDnsName(ServiceDnsName.unwrap(serviceDnsName): java.lang.String)
      .optionallyWith(
        vpceConfigurationDescription.map(value =>
          VPCEConfigurationDescription.unwrap(value): java.lang.String
        )
      )(_.vpceConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateVpceConfigurationRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateVpceConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateVpceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateVpceConfigurationRequest =
      zio.aws.devicefarm.model.CreateVpceConfigurationRequest(
        vpceConfigurationName,
        vpceServiceName,
        serviceDnsName,
        vpceConfigurationDescription.map(value => value)
      )
    def vpceConfigurationName: VPCEConfigurationName
    def vpceServiceName: VPCEServiceName
    def serviceDnsName: ServiceDnsName
    def vpceConfigurationDescription: Option[VPCEConfigurationDescription]
    def getVpceConfigurationName: ZIO[Any, Nothing, VPCEConfigurationName] =
      ZIO.succeed(vpceConfigurationName)
    def getVpceServiceName: ZIO[Any, Nothing, VPCEServiceName] =
      ZIO.succeed(vpceServiceName)
    def getServiceDnsName: ZIO[Any, Nothing, ServiceDnsName] =
      ZIO.succeed(serviceDnsName)
    def getVpceConfigurationDescription
        : ZIO[Any, AwsError, VPCEConfigurationDescription] =
      AwsError.unwrapOptionField(
        "vpceConfigurationDescription",
        vpceConfigurationDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest
  ) extends zio.aws.devicefarm.model.CreateVpceConfigurationRequest.ReadOnly {
    override val vpceConfigurationName: VPCEConfigurationName =
      zio.aws.devicefarm.model.primitives
        .VPCEConfigurationName(impl.vpceConfigurationName())
    override val vpceServiceName: VPCEServiceName =
      zio.aws.devicefarm.model.primitives
        .VPCEServiceName(impl.vpceServiceName())
    override val serviceDnsName: ServiceDnsName =
      zio.aws.devicefarm.model.primitives.ServiceDnsName(impl.serviceDnsName())
    override val vpceConfigurationDescription
        : Option[VPCEConfigurationDescription] = scala
      .Option(impl.vpceConfigurationDescription())
      .map(value =>
        zio.aws.devicefarm.model.primitives.VPCEConfigurationDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest
  ): zio.aws.devicefarm.model.CreateVpceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
