package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CustomerArtifactPaths(
    iosPaths: Option[Iterable[String]] = None,
    androidPaths: Option[Iterable[String]] = None,
    deviceHostPaths: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths = {
    import CustomerArtifactPaths.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths
      .builder()
      .optionallyWith(
        iosPaths.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.iosPaths)
      .optionallyWith(
        androidPaths.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.androidPaths)
      .optionallyWith(
        deviceHostPaths.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.deviceHostPaths)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly =
    zio.aws.devicefarm.model.CustomerArtifactPaths.wrap(buildAwsValue())
}
object CustomerArtifactPaths {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CustomerArtifactPaths =
      zio.aws.devicefarm.model.CustomerArtifactPaths(
        iosPaths.map(value => value),
        androidPaths.map(value => value),
        deviceHostPaths.map(value => value)
      )
    def iosPaths: Option[List[String]]
    def androidPaths: Option[List[String]]
    def deviceHostPaths: Option[List[String]]
    def getIosPaths: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("iosPaths", iosPaths)
    def getAndroidPaths: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("androidPaths", androidPaths)
    def getDeviceHostPaths: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("deviceHostPaths", deviceHostPaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths
  ) extends zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly {
    override val iosPaths: Option[List[String]] = scala
      .Option(impl.iosPaths())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val androidPaths: Option[List[String]] = scala
      .Option(impl.androidPaths())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val deviceHostPaths: Option[List[String]] = scala
      .Option(impl.deviceHostPaths())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths
  ): zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly = new Wrapper(impl)
}
