package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDevicePoolRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest = {
    import DeleteDevicePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DeleteDevicePoolRequest.ReadOnly =
    zio.aws.devicefarm.model.DeleteDevicePoolRequest.wrap(buildAwsValue())
}
object DeleteDevicePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeleteDevicePoolRequest =
      zio.aws.devicefarm.model.DeleteDevicePoolRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest
  ) extends zio.aws.devicefarm.model.DeleteDevicePoolRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest
  ): zio.aws.devicefarm.model.DeleteDevicePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
