package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteNetworkProfileRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest = {
    import DeleteNetworkProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.DeleteNetworkProfileRequest.ReadOnly =
    zio.aws.devicefarm.model.DeleteNetworkProfileRequest.wrap(buildAwsValue())
}
object DeleteNetworkProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeleteNetworkProfileRequest =
      zio.aws.devicefarm.model.DeleteNetworkProfileRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest
  ) extends zio.aws.devicefarm.model.DeleteNetworkProfileRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest
  ): zio.aws.devicefarm.model.DeleteNetworkProfileRequest.ReadOnly =
    new Wrapper(impl)
}
