package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.DeviceFarmArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTestGridProjectRequest(projectArn: DeviceFarmArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectRequest = {
    import DeleteTestGridProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectRequest
      .builder()
      .projectArn(DeviceFarmArn.unwrap(projectArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.DeleteTestGridProjectRequest.ReadOnly =
    zio.aws.devicefarm.model.DeleteTestGridProjectRequest.wrap(buildAwsValue())
}
object DeleteTestGridProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeleteTestGridProjectRequest =
      zio.aws.devicefarm.model.DeleteTestGridProjectRequest(projectArn)
    def projectArn: DeviceFarmArn
    def getProjectArn: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectRequest
  ) extends zio.aws.devicefarm.model.DeleteTestGridProjectRequest.ReadOnly {
    override val projectArn: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.projectArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectRequest
  ): zio.aws.devicefarm.model.DeleteTestGridProjectRequest.ReadOnly =
    new Wrapper(impl)
}
