package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteUploadRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest = {
    import DeleteUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DeleteUploadRequest.ReadOnly =
    zio.aws.devicefarm.model.DeleteUploadRequest.wrap(buildAwsValue())
}
object DeleteUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeleteUploadRequest =
      zio.aws.devicefarm.model.DeleteUploadRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest
  ) extends zio.aws.devicefarm.model.DeleteUploadRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest
  ): zio.aws.devicefarm.model.DeleteUploadRequest.ReadOnly = new Wrapper(impl)
}
