package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteVpceConfigurationRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest = {
    import DeleteVpceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.DeleteVpceConfigurationRequest.ReadOnly =
    zio.aws.devicefarm.model.DeleteVpceConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteVpceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeleteVpceConfigurationRequest =
      zio.aws.devicefarm.model.DeleteVpceConfigurationRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest
  ) extends zio.aws.devicefarm.model.DeleteVpceConfigurationRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest
  ): zio.aws.devicefarm.model.DeleteVpceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
