package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Name, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Device(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    manufacturer: Option[String] = None,
    model: Option[String] = None,
    modelId: Option[String] = None,
    formFactor: Option[zio.aws.devicefarm.model.DeviceFormFactor] = None,
    platform: Option[zio.aws.devicefarm.model.DevicePlatform] = None,
    os: Option[String] = None,
    cpu: Option[zio.aws.devicefarm.model.CPU] = None,
    resolution: Option[zio.aws.devicefarm.model.Resolution] = None,
    heapSize: Option[Long] = None,
    memory: Option[Long] = None,
    image: Option[String] = None,
    carrier: Option[String] = None,
    radio: Option[String] = None,
    remoteAccessEnabled: Option[Boolean] = None,
    remoteDebugEnabled: Option[Boolean] = None,
    fleetType: Option[String] = None,
    fleetName: Option[String] = None,
    instances: Option[Iterable[zio.aws.devicefarm.model.DeviceInstance]] = None,
    availability: Option[zio.aws.devicefarm.model.DeviceAvailability] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Device
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(manufacturer.map(value => value: java.lang.String))(
        _.manufacturer
      )
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(modelId.map(value => value: java.lang.String))(_.modelId)
      .optionallyWith(formFactor.map(value => value.unwrap))(_.formFactor)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(os.map(value => value: java.lang.String))(_.os)
      .optionallyWith(cpu.map(value => value.buildAwsValue()))(_.cpu)
      .optionallyWith(resolution.map(value => value.buildAwsValue()))(
        _.resolution
      )
      .optionallyWith(heapSize.map(value => value: java.lang.Long))(_.heapSize)
      .optionallyWith(memory.map(value => value: java.lang.Long))(_.memory)
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(carrier.map(value => value: java.lang.String))(_.carrier)
      .optionallyWith(radio.map(value => value: java.lang.String))(_.radio)
      .optionallyWith(
        remoteAccessEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteAccessEnabled)
      .optionallyWith(
        remoteDebugEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteDebugEnabled)
      .optionallyWith(fleetType.map(value => value: java.lang.String))(
        _.fleetType
      )
      .optionallyWith(fleetName.map(value => value: java.lang.String))(
        _.fleetName
      )
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(availability.map(value => value.unwrap))(_.availability)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Device.ReadOnly =
    zio.aws.devicefarm.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Device] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Device =
      zio.aws.devicefarm.model.Device(
        arn.map(value => value),
        name.map(value => value),
        manufacturer.map(value => value),
        model.map(value => value),
        modelId.map(value => value),
        formFactor.map(value => value),
        platform.map(value => value),
        os.map(value => value),
        cpu.map(value => value.asEditable),
        resolution.map(value => value.asEditable),
        heapSize.map(value => value),
        memory.map(value => value),
        image.map(value => value),
        carrier.map(value => value),
        radio.map(value => value),
        remoteAccessEnabled.map(value => value),
        remoteDebugEnabled.map(value => value),
        fleetType.map(value => value),
        fleetName.map(value => value),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availability.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def manufacturer: Option[String]
    def model: Option[String]
    def modelId: Option[String]
    def formFactor: Option[zio.aws.devicefarm.model.DeviceFormFactor]
    def platform: Option[zio.aws.devicefarm.model.DevicePlatform]
    def os: Option[String]
    def cpu: Option[zio.aws.devicefarm.model.CPU.ReadOnly]
    def resolution: Option[zio.aws.devicefarm.model.Resolution.ReadOnly]
    def heapSize: Option[Long]
    def memory: Option[Long]
    def image: Option[String]
    def carrier: Option[String]
    def radio: Option[String]
    def remoteAccessEnabled: Option[Boolean]
    def remoteDebugEnabled: Option[Boolean]
    def fleetType: Option[String]
    def fleetName: Option[String]
    def instances
        : Option[List[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]]
    def availability: Option[zio.aws.devicefarm.model.DeviceAvailability]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getManufacturer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("manufacturer", manufacturer)
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
    def getModelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelId", modelId)
    def getFormFactor
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceFormFactor] =
      AwsError.unwrapOptionField("formFactor", formFactor)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOs: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("os", os)
    def getCpu: ZIO[Any, AwsError, zio.aws.devicefarm.model.CPU.ReadOnly] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getResolution
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Resolution.ReadOnly] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getHeapSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("heapSize", heapSize)
    def getMemory: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("memory", memory)
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getCarrier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("carrier", carrier)
    def getRadio: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("radio", radio)
    def getRemoteAccessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteAccessEnabled", remoteAccessEnabled)
    def getRemoteDebugEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteDebugEnabled", remoteDebugEnabled)
    def getFleetType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getFleetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fleetName", fleetName)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DeviceInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getAvailability
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceAvailability] =
      AwsError.unwrapOptionField("availability", availability)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Device
  ) extends zio.aws.devicefarm.model.Device.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val manufacturer: Option[String] =
      scala.Option(impl.manufacturer()).map(value => value: String)
    override val model: Option[String] =
      scala.Option(impl.model()).map(value => value: String)
    override val modelId: Option[String] =
      scala.Option(impl.modelId()).map(value => value: String)
    override val formFactor: Option[zio.aws.devicefarm.model.DeviceFormFactor] =
      scala
        .Option(impl.formFactor())
        .map(value => zio.aws.devicefarm.model.DeviceFormFactor.wrap(value))
    override val platform: Option[zio.aws.devicefarm.model.DevicePlatform] =
      scala
        .Option(impl.platform())
        .map(value => zio.aws.devicefarm.model.DevicePlatform.wrap(value))
    override val os: Option[String] =
      scala.Option(impl.os()).map(value => value: String)
    override val cpu: Option[zio.aws.devicefarm.model.CPU.ReadOnly] = scala
      .Option(impl.cpu())
      .map(value => zio.aws.devicefarm.model.CPU.wrap(value))
    override val resolution
        : Option[zio.aws.devicefarm.model.Resolution.ReadOnly] = scala
      .Option(impl.resolution())
      .map(value => zio.aws.devicefarm.model.Resolution.wrap(value))
    override val heapSize: Option[Long] =
      scala.Option(impl.heapSize()).map(value => value: Long)
    override val memory: Option[Long] =
      scala.Option(impl.memory()).map(value => value: Long)
    override val image: Option[String] =
      scala.Option(impl.image()).map(value => value: String)
    override val carrier: Option[String] =
      scala.Option(impl.carrier()).map(value => value: String)
    override val radio: Option[String] =
      scala.Option(impl.radio()).map(value => value: String)
    override val remoteAccessEnabled: Option[Boolean] =
      scala.Option(impl.remoteAccessEnabled()).map(value => value: Boolean)
    override val remoteDebugEnabled: Option[Boolean] =
      scala.Option(impl.remoteDebugEnabled()).map(value => value: Boolean)
    override val fleetType: Option[String] =
      scala.Option(impl.fleetType()).map(value => value: String)
    override val fleetName: Option[String] =
      scala.Option(impl.fleetName()).map(value => value: String)
    override val instances
        : Option[List[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.DeviceInstance.wrap(item)
        }.toList
      )
    override val availability
        : Option[zio.aws.devicefarm.model.DeviceAvailability] = scala
      .Option(impl.availability())
      .map(value => zio.aws.devicefarm.model.DeviceAvailability.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Device
  ): zio.aws.devicefarm.model.Device.ReadOnly = new Wrapper(impl)
}
