package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceAvailability {
  def unwrap
      : software.amazon.awssdk.services.devicefarm.model.DeviceAvailability
}
object DeviceAvailability {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.DeviceAvailability
  ): zio.aws.devicefarm.model.DeviceAvailability = value match {
    case software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.TEMPORARY_NOT_AVAILABLE =>
      val r = TEMPORARY_NOT_AVAILABLE
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.BUSY =>
      val r = BUSY
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.HIGHLY_AVAILABLE =>
      val r = HIGHLY_AVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.DeviceAvailability {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAvailability =
      software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.UNKNOWN_TO_SDK_VERSION
  }
  case object TEMPORARY_NOT_AVAILABLE
      extends zio.aws.devicefarm.model.DeviceAvailability {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAvailability =
      software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.TEMPORARY_NOT_AVAILABLE
  }
  case object BUSY extends zio.aws.devicefarm.model.DeviceAvailability {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAvailability =
      software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.BUSY
  }
  case object AVAILABLE extends zio.aws.devicefarm.model.DeviceAvailability {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAvailability =
      software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.AVAILABLE
  }
  case object HIGHLY_AVAILABLE
      extends zio.aws.devicefarm.model.DeviceAvailability {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAvailability =
      software.amazon.awssdk.services.devicefarm.model.DeviceAvailability.HIGHLY_AVAILABLE
  }
}
