package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceFilterAttribute {
  def unwrap
      : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute
}
object DeviceFilterAttribute {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute
  ): zio.aws.devicefarm.model.DeviceFilterAttribute = value match {
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.ARN =>
      val r = ARN
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.PLATFORM =>
      val r = PLATFORM
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.OS_VERSION =>
      val r = OS_VERSION
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.MODEL =>
      val r = MODEL
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.AVAILABILITY =>
      val r = AVAILABILITY
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.FORM_FACTOR =>
      val r = FORM_FACTOR
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.MANUFACTURER =>
      val r = MANUFACTURER
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.REMOTE_ACCESS_ENABLED =>
      val r = REMOTE_ACCESS_ENABLED
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.REMOTE_DEBUG_ENABLED =>
      val r = REMOTE_DEBUG_ENABLED
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.INSTANCE_ARN =>
      val r = INSTANCE_ARN
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.INSTANCE_LABELS =>
      val r = INSTANCE_LABELS
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.FLEET_TYPE =>
      val r = FLEET_TYPE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object ARN extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.ARN
  }
  case object PLATFORM extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.PLATFORM
  }
  case object OS_VERSION
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.OS_VERSION
  }
  case object MODEL extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.MODEL
  }
  case object AVAILABILITY
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.AVAILABILITY
  }
  case object FORM_FACTOR
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.FORM_FACTOR
  }
  case object MANUFACTURER
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.MANUFACTURER
  }
  case object REMOTE_ACCESS_ENABLED
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.REMOTE_ACCESS_ENABLED
  }
  case object REMOTE_DEBUG_ENABLED
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.REMOTE_DEBUG_ENABLED
  }
  case object INSTANCE_ARN
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.INSTANCE_ARN
  }
  case object INSTANCE_LABELS
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.INSTANCE_LABELS
  }
  case object FLEET_TYPE
      extends zio.aws.devicefarm.model.DeviceFilterAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceFilterAttribute.FLEET_TYPE
  }
}
