package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeviceInstance(
    arn: Option[AmazonResourceName] = None,
    deviceArn: Option[AmazonResourceName] = None,
    labels: Option[Iterable[String]] = None,
    status: Option[zio.aws.devicefarm.model.InstanceStatus] = None,
    udid: Option[String] = None,
    instanceProfile: Option[zio.aws.devicefarm.model.InstanceProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeviceInstance = {
    import DeviceInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeviceInstance
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        deviceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.deviceArn)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(udid.map(value => value: java.lang.String))(_.udid)
      .optionallyWith(instanceProfile.map(value => value.buildAwsValue()))(
        _.instanceProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DeviceInstance.ReadOnly =
    zio.aws.devicefarm.model.DeviceInstance.wrap(buildAwsValue())
}
object DeviceInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeviceInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeviceInstance =
      zio.aws.devicefarm.model.DeviceInstance(
        arn.map(value => value),
        deviceArn.map(value => value),
        labels.map(value => value),
        status.map(value => value),
        udid.map(value => value),
        instanceProfile.map(value => value.asEditable)
      )
    def arn: Option[AmazonResourceName]
    def deviceArn: Option[AmazonResourceName]
    def labels: Option[List[String]]
    def status: Option[zio.aws.devicefarm.model.InstanceStatus]
    def udid: Option[String]
    def instanceProfile
        : Option[zio.aws.devicefarm.model.InstanceProfile.ReadOnly]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getDeviceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getLabels: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("labels", labels)
    def getStatus: ZIO[Any, AwsError, zio.aws.devicefarm.model.InstanceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUdid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("udid", udid)
    def getInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.InstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("instanceProfile", instanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceInstance
  ) extends zio.aws.devicefarm.model.DeviceInstance.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val deviceArn: Option[AmazonResourceName] = scala
      .Option(impl.deviceArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val labels: Option[List[String]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Option[zio.aws.devicefarm.model.InstanceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devicefarm.model.InstanceStatus.wrap(value))
    override val udid: Option[String] =
      scala.Option(impl.udid()).map(value => value: String)
    override val instanceProfile
        : Option[zio.aws.devicefarm.model.InstanceProfile.ReadOnly] = scala
      .Option(impl.instanceProfile())
      .map(value => zio.aws.devicefarm.model.InstanceProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceInstance
  ): zio.aws.devicefarm.model.DeviceInstance.ReadOnly = new Wrapper(impl)
}
