package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait DevicePlatform {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.DevicePlatform
}
object DevicePlatform {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.DevicePlatform
  ): zio.aws.devicefarm.model.DevicePlatform = value match {
    case software.amazon.awssdk.services.devicefarm.model.DevicePlatform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.DevicePlatform.ANDROID =>
      val r = ANDROID
      r
    case software.amazon.awssdk.services.devicefarm.model.DevicePlatform.IOS =>
      val r = IOS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.DevicePlatform {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DevicePlatform =
      software.amazon.awssdk.services.devicefarm.model.DevicePlatform.UNKNOWN_TO_SDK_VERSION
  }
  case object ANDROID extends zio.aws.devicefarm.model.DevicePlatform {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DevicePlatform =
      software.amazon.awssdk.services.devicefarm.model.DevicePlatform.ANDROID
  }
  case object IOS extends zio.aws.devicefarm.model.DevicePlatform {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DevicePlatform =
      software.amazon.awssdk.services.devicefarm.model.DevicePlatform.IOS
  }
}
