package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  Integer,
  Message,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DevicePool(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    description: Option[Message] = None,
    `type`: Option[zio.aws.devicefarm.model.DevicePoolType] = None,
    rules: Option[Iterable[zio.aws.devicefarm.model.Rule]] = None,
    maxDevices: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DevicePool = {
    import DevicePool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DevicePool
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        maxDevices.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxDevices)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DevicePool.ReadOnly =
    zio.aws.devicefarm.model.DevicePool.wrap(buildAwsValue())
}
object DevicePool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DevicePool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DevicePool =
      zio.aws.devicefarm.model.DevicePool(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxDevices.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def description: Option[Message]
    def `type`: Option[zio.aws.devicefarm.model.DevicePoolType]
    def rules: Option[List[zio.aws.devicefarm.model.Rule.ReadOnly]]
    def maxDevices: Option[Integer]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePoolType] =
      AwsError.unwrapOptionField("type", `type`)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getMaxDevices: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxDevices", maxDevices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DevicePool
  ) extends zio.aws.devicefarm.model.DevicePool.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val description: Option[Message] = scala
      .Option(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val `type`: Option[zio.aws.devicefarm.model.DevicePoolType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.DevicePoolType.wrap(value))
    override val rules: Option[List[zio.aws.devicefarm.model.Rule.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Rule.wrap(item)
          }.toList
        )
    override val maxDevices: Option[Integer] = scala
      .Option(impl.maxDevices())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DevicePool
  ): zio.aws.devicefarm.model.DevicePool.ReadOnly = new Wrapper(impl)
}
