package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DevicePoolCompatibilityResult(
    device: Option[zio.aws.devicefarm.model.Device] = None,
    compatible: Option[Boolean] = None,
    incompatibilityMessages: Option[
      Iterable[zio.aws.devicefarm.model.IncompatibilityMessage]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResult = {
    import DevicePoolCompatibilityResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResult
      .builder()
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .optionallyWith(compatible.map(value => value: java.lang.Boolean))(
        _.compatible
      )
      .optionallyWith(
        incompatibilityMessages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.incompatibilityMessages)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly =
    zio.aws.devicefarm.model.DevicePoolCompatibilityResult.wrap(buildAwsValue())
}
object DevicePoolCompatibilityResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DevicePoolCompatibilityResult =
      zio.aws.devicefarm.model.DevicePoolCompatibilityResult(
        device.map(value => value.asEditable),
        compatible.map(value => value),
        incompatibilityMessages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def device: Option[zio.aws.devicefarm.model.Device.ReadOnly]
    def compatible: Option[Boolean]
    def incompatibilityMessages
        : Option[List[zio.aws.devicefarm.model.IncompatibilityMessage.ReadOnly]]
    def getDevice
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
    def getCompatible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("compatible", compatible)
    def getIncompatibilityMessages: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.IncompatibilityMessage.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "incompatibilityMessages",
      incompatibilityMessages
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResult
  ) extends zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly {
    override val device: Option[zio.aws.devicefarm.model.Device.ReadOnly] =
      scala
        .Option(impl.device())
        .map(value => zio.aws.devicefarm.model.Device.wrap(value))
    override val compatible: Option[Boolean] =
      scala.Option(impl.compatible()).map(value => value: Boolean)
    override val incompatibilityMessages: Option[
      List[zio.aws.devicefarm.model.IncompatibilityMessage.ReadOnly]
    ] = scala
      .Option(impl.incompatibilityMessages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.IncompatibilityMessage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResult
  ): zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly =
    new Wrapper(impl)
}
