package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait DevicePoolType {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.DevicePoolType
}
object DevicePoolType {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.DevicePoolType
  ): zio.aws.devicefarm.model.DevicePoolType = value match {
    case software.amazon.awssdk.services.devicefarm.model.DevicePoolType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.DevicePoolType.CURATED =>
      val r = CURATED
      r
    case software.amazon.awssdk.services.devicefarm.model.DevicePoolType.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.DevicePoolType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DevicePoolType =
      software.amazon.awssdk.services.devicefarm.model.DevicePoolType.UNKNOWN_TO_SDK_VERSION
  }
  case object CURATED extends zio.aws.devicefarm.model.DevicePoolType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DevicePoolType =
      software.amazon.awssdk.services.devicefarm.model.DevicePoolType.CURATED
  }
  case object PRIVATE extends zio.aws.devicefarm.model.DevicePoolType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DevicePoolType =
      software.amazon.awssdk.services.devicefarm.model.DevicePoolType.PRIVATE
  }
}
