package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeviceSelectionResult(
    filters: Option[Iterable[zio.aws.devicefarm.model.DeviceFilter]] = None,
    matchedDevicesCount: Option[Integer] = None,
    maxDevices: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult = {
    import DeviceSelectionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        matchedDevicesCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.matchedDevicesCount)
      .optionallyWith(
        maxDevices.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxDevices)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly =
    zio.aws.devicefarm.model.DeviceSelectionResult.wrap(buildAwsValue())
}
object DeviceSelectionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeviceSelectionResult =
      zio.aws.devicefarm.model.DeviceSelectionResult(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        matchedDevicesCount.map(value => value),
        maxDevices.map(value => value)
      )
    def filters: Option[List[zio.aws.devicefarm.model.DeviceFilter.ReadOnly]]
    def matchedDevicesCount: Option[Integer]
    def maxDevices: Option[Integer]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DeviceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMatchedDevicesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("matchedDevicesCount", matchedDevicesCount)
    def getMaxDevices: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxDevices", maxDevices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult
  ) extends zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly {
    override val filters
        : Option[List[zio.aws.devicefarm.model.DeviceFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.DeviceFilter.wrap(item)
        }.toList
      )
    override val matchedDevicesCount: Option[Integer] = scala
      .Option(impl.matchedDevicesCount())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val maxDevices: Option[Integer] = scala
      .Option(impl.maxDevices())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult
  ): zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly = new Wrapper(impl)
}
