package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionStatus {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.ExecutionStatus
}
object ExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.ExecutionStatus
  ): zio.aws.devicefarm.model.ExecutionStatus = value match {
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PENDING_CONCURRENCY =>
      val r = PENDING_CONCURRENCY
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PENDING_DEVICE =>
      val r = PENDING_DEVICE
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.SCHEDULING =>
      val r = SCHEDULING
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PREPARING =>
      val r = PREPARING
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.STOPPING =>
      val r = STOPPING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PENDING
  }
  case object PENDING_CONCURRENCY
      extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PENDING_CONCURRENCY
  }
  case object PENDING_DEVICE extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PENDING_DEVICE
  }
  case object PROCESSING extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PROCESSING
  }
  case object SCHEDULING extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.SCHEDULING
  }
  case object PREPARING extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.PREPARING
  }
  case object RUNNING extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.COMPLETED
  }
  case object STOPPING extends zio.aws.devicefarm.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionStatus =
      software.amazon.awssdk.services.devicefarm.model.ExecutionStatus.STOPPING
  }
}
