package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAccountSettingsResponse(
    accountSettings: Option[zio.aws.devicefarm.model.AccountSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse = {
    import GetAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse
      .builder()
      .optionallyWith(accountSettings.map(value => value.buildAwsValue()))(
        _.accountSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetAccountSettingsResponse.ReadOnly =
    zio.aws.devicefarm.model.GetAccountSettingsResponse.wrap(buildAwsValue())
}
object GetAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetAccountSettingsResponse =
      zio.aws.devicefarm.model.GetAccountSettingsResponse(
        accountSettings.map(value => value.asEditable)
      )
    def accountSettings
        : Option[zio.aws.devicefarm.model.AccountSettings.ReadOnly]
    def getAccountSettings: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.AccountSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accountSettings", accountSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse
  ) extends zio.aws.devicefarm.model.GetAccountSettingsResponse.ReadOnly {
    override val accountSettings
        : Option[zio.aws.devicefarm.model.AccountSettings.ReadOnly] = scala
      .Option(impl.accountSettings())
      .map(value => zio.aws.devicefarm.model.AccountSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse
  ): zio.aws.devicefarm.model.GetAccountSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
