package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDeviceInstanceRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest = {
    import GetDeviceInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetDeviceInstanceRequest.ReadOnly =
    zio.aws.devicefarm.model.GetDeviceInstanceRequest.wrap(buildAwsValue())
}
object GetDeviceInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetDeviceInstanceRequest =
      zio.aws.devicefarm.model.GetDeviceInstanceRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest
  ) extends zio.aws.devicefarm.model.GetDeviceInstanceRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest
  ): zio.aws.devicefarm.model.GetDeviceInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
