package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDeviceInstanceResponse(
    deviceInstance: Option[zio.aws.devicefarm.model.DeviceInstance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceResponse = {
    import GetDeviceInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceResponse
      .builder()
      .optionallyWith(deviceInstance.map(value => value.buildAwsValue()))(
        _.deviceInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetDeviceInstanceResponse.ReadOnly =
    zio.aws.devicefarm.model.GetDeviceInstanceResponse.wrap(buildAwsValue())
}
object GetDeviceInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetDeviceInstanceResponse =
      zio.aws.devicefarm.model.GetDeviceInstanceResponse(
        deviceInstance.map(value => value.asEditable)
      )
    def deviceInstance: Option[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]
    def getDeviceInstance
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceInstance.ReadOnly] =
      AwsError.unwrapOptionField("deviceInstance", deviceInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceResponse
  ) extends zio.aws.devicefarm.model.GetDeviceInstanceResponse.ReadOnly {
    override val deviceInstance
        : Option[zio.aws.devicefarm.model.DeviceInstance.ReadOnly] = scala
      .Option(impl.deviceInstance())
      .map(value => zio.aws.devicefarm.model.DeviceInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceResponse
  ): zio.aws.devicefarm.model.GetDeviceInstanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
