package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDevicePoolCompatibilityRequest(
    devicePoolArn: AmazonResourceName,
    appArn: Option[AmazonResourceName] = None,
    testType: Option[zio.aws.devicefarm.model.TestType] = None,
    test: Option[zio.aws.devicefarm.model.ScheduleRunTest] = None,
    configuration: Option[zio.aws.devicefarm.model.ScheduleRunConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest = {
    import GetDevicePoolCompatibilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest
      .builder()
      .devicePoolArn(AmazonResourceName.unwrap(devicePoolArn): java.lang.String)
      .optionallyWith(
        appArn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.appArn)
      .optionallyWith(testType.map(value => value.unwrap))(_.testType)
      .optionallyWith(test.map(value => value.buildAwsValue()))(_.test)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest.ReadOnly =
    zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest
      .wrap(buildAwsValue())
}
object GetDevicePoolCompatibilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest =
      zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest(
        devicePoolArn,
        appArn.map(value => value),
        testType.map(value => value),
        test.map(value => value.asEditable),
        configuration.map(value => value.asEditable)
      )
    def devicePoolArn: AmazonResourceName
    def appArn: Option[AmazonResourceName]
    def testType: Option[zio.aws.devicefarm.model.TestType]
    def test: Option[zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly]
    def configuration
        : Option[zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly]
    def getDevicePoolArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(devicePoolArn)
    def getAppArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("appArn", appArn)
    def getTestType: ZIO[Any, AwsError, zio.aws.devicefarm.model.TestType] =
      AwsError.unwrapOptionField("testType", testType)
    def getTest: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly
    ] = AwsError.unwrapOptionField("test", test)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest
  ) extends zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest.ReadOnly {
    override val devicePoolArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives
        .AmazonResourceName(impl.devicePoolArn())
    override val appArn: Option[AmazonResourceName] = scala
      .Option(impl.appArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val testType: Option[zio.aws.devicefarm.model.TestType] = scala
      .Option(impl.testType())
      .map(value => zio.aws.devicefarm.model.TestType.wrap(value))
    override val test
        : Option[zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly] = scala
      .Option(impl.test())
      .map(value => zio.aws.devicefarm.model.ScheduleRunTest.wrap(value))
    override val configuration
        : Option[zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly] =
      scala
        .Option(impl.configuration())
        .map(value =>
          zio.aws.devicefarm.model.ScheduleRunConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest
  ): zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest.ReadOnly =
    new Wrapper(impl)
}
