package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDevicePoolResponse(
    devicePool: Option[zio.aws.devicefarm.model.DevicePool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse = {
    import GetDevicePoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse
      .builder()
      .optionallyWith(devicePool.map(value => value.buildAwsValue()))(
        _.devicePool
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetDevicePoolResponse.ReadOnly =
    zio.aws.devicefarm.model.GetDevicePoolResponse.wrap(buildAwsValue())
}
object GetDevicePoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetDevicePoolResponse =
      zio.aws.devicefarm.model
        .GetDevicePoolResponse(devicePool.map(value => value.asEditable))
    def devicePool: Option[zio.aws.devicefarm.model.DevicePool.ReadOnly]
    def getDevicePool
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePool.ReadOnly] =
      AwsError.unwrapOptionField("devicePool", devicePool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse
  ) extends zio.aws.devicefarm.model.GetDevicePoolResponse.ReadOnly {
    override val devicePool
        : Option[zio.aws.devicefarm.model.DevicePool.ReadOnly] = scala
      .Option(impl.devicePool())
      .map(value => zio.aws.devicefarm.model.DevicePool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse
  ): zio.aws.devicefarm.model.GetDevicePoolResponse.ReadOnly = new Wrapper(impl)
}
