package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDeviceResponse(
    device: Option[zio.aws.devicefarm.model.Device] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse = {
    import GetDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse
      .builder()
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetDeviceResponse.ReadOnly =
    zio.aws.devicefarm.model.GetDeviceResponse.wrap(buildAwsValue())
}
object GetDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetDeviceResponse =
      zio.aws.devicefarm.model
        .GetDeviceResponse(device.map(value => value.asEditable))
    def device: Option[zio.aws.devicefarm.model.Device.ReadOnly]
    def getDevice
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse
  ) extends zio.aws.devicefarm.model.GetDeviceResponse.ReadOnly {
    override val device: Option[zio.aws.devicefarm.model.Device.ReadOnly] =
      scala
        .Option(impl.device())
        .map(value => zio.aws.devicefarm.model.Device.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse
  ): zio.aws.devicefarm.model.GetDeviceResponse.ReadOnly = new Wrapper(impl)
}
