package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetNetworkProfileResponse(
    networkProfile: Option[zio.aws.devicefarm.model.NetworkProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse = {
    import GetNetworkProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse
      .builder()
      .optionallyWith(networkProfile.map(value => value.buildAwsValue()))(
        _.networkProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetNetworkProfileResponse.ReadOnly =
    zio.aws.devicefarm.model.GetNetworkProfileResponse.wrap(buildAwsValue())
}
object GetNetworkProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetNetworkProfileResponse =
      zio.aws.devicefarm.model.GetNetworkProfileResponse(
        networkProfile.map(value => value.asEditable)
      )
    def networkProfile: Option[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]
    def getNetworkProfile
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfile.ReadOnly] =
      AwsError.unwrapOptionField("networkProfile", networkProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse
  ) extends zio.aws.devicefarm.model.GetNetworkProfileResponse.ReadOnly {
    override val networkProfile
        : Option[zio.aws.devicefarm.model.NetworkProfile.ReadOnly] = scala
      .Option(impl.networkProfile())
      .map(value => zio.aws.devicefarm.model.NetworkProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse
  ): zio.aws.devicefarm.model.GetNetworkProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
